package edu.uky.ai.lp.ai;

import java.io.BufferedReader;
import java.io.IOException;

import edu.uky.ai.lp.Action;
import edu.uky.ai.lp.Game;
import edu.uky.ai.lp.Result;
import edu.uky.ai.lp.gui.Console;

/**
 * An implementation of {@link Agent} that allows a human to play the game by
 * typing commands into the console.
 * 
 * @author Stephen G. Ware
 */
public class HumanAgent implements Agent {

	/** A means of reading console input */
	private final BufferedReader in;
	
	/**
	 * Creates a new human agent which accepts input via the console.
	 * 
	 * @param console the console from which to get input
	 * @throws IOException if an I/O exception occurs
	 */
	public HumanAgent(Console console) throws IOException {
		in = new BufferedReader(console.getInputReader());
		console.setEditable(true);
	}
	
	@Override
	public Action chooseAction(Game game) {
		try {
			String input = in.readLine();
			System.out.println(input);
			if(input.equalsIgnoreCase("up"))
				return Action.UP;
			else if(input.equalsIgnoreCase("RIGHT"))
				return Action.RIGHT;
			else if(input.equalsIgnoreCase("DOWN"))
				return Action.DOWN;
			else if(input.equalsIgnoreCase("LEFT"))
				return Action.LEFT;
			else if(input.equalsIgnoreCase("GRAB"))
				return Action.GRAB;
		}
		catch(Exception ex) {
			ex.printStackTrace();
		}
		return null;
	}

	@Override
	public void observe(Result result) {
		System.out.println(result);
	}
}
